# Postman Collection for Samaa Backend Authentication

This directory contains Postman collections and environments for testing the Samaa Backend Authentication API.

## Files

- **Samaa_Backend_Auth.postman_collection.json** - Main Postman collection with all authentication endpoints
- **Samaa_Backend_Environment.postman_environment.json** - Postman environment file with variables

## Setup Instructions

### 1. Import Collection and Environment

1. Open Postman
2. Click **Import** button (top left)
3. Import both files:
   - `Samaa_Backend_Auth.postman_collection.json`
   - `Samaa_Backend_Environment.postman_environment.json`

### 2. Configure Environment

1. Select the **Samaa Backend - Development** environment from the environment dropdown (top right)
2. Verify the `base_url` is set to `http://localhost:3000` (or your server URL)
3. The `auth_token` will be automatically set after successful login

### 3. Using the Collection

#### Step 1: Login
1. Open the **Authentication > Login** request
2. The default credentials are:
   - Email: `admin@samaa.com`
   - Password: `Admin@123`
3. Click **Send**
4. On success, the token will be automatically saved to the environment variable `auth_token`

#### Step 2: Test Protected Routes
1. Open **Authentication > Get Current Admin Profile**
2. Click **Send** - The token will be automatically included in the Authorization header
3. Open **Authentication > Logout**
4. Click **Send** - This will log you out

## Collection Structure

```
Authentication
├── Login (POST /api/auth/login)
│   ├── Success - Login
│   ├── Error - Invalid Credentials
│   └── Error - Missing Fields
├── Get Current Admin Profile (GET /api/auth/me)
│   ├── Success - Get Profile
│   ├── Error - No Token
│   └── Error - Invalid Token
└── Logout (POST /api/auth/logout)
    └── Success - Logout
```

## Environment Variables

The collection uses the following environment variables:

- **base_url** - Base URL of your API (default: `http://localhost:3000`)
- **auth_token** - JWT token (automatically set after login)
- **admin_id** - Admin user ID (automatically set after login)
- **admin_email** - Admin email (default: `admin@samaa.com`)

## Features

### Automatic Token Management
- The Login request automatically saves the token to the environment
- Protected routes automatically use the saved token
- No need to manually copy/paste tokens

### Example Responses
- Each request includes example success and error responses
- Use these as reference for expected API behavior

### Pre-request Scripts
- Some requests include pre-request scripts to validate tokens
- Warnings are shown if required variables are missing

### Test Scripts
- Login request includes a test script that saves the token
- Logout request includes a test script for cleanup

## Testing Different Scenarios

### Test Invalid Login
1. Open **Login** request
2. Change email or password to invalid values
3. Click **Send**
4. Check the error response

### Test Without Token
1. Clear the `auth_token` environment variable
2. Try **Get Current Admin Profile**
3. You should receive a 401 Unauthorized error

### Test Expired Token
1. Use an old/expired token
2. Try any protected route
3. You should receive a 401 error with "Token expired" message

## Tips

1. **Always login first** - The token is required for protected routes
2. **Check environment variables** - Make sure `base_url` matches your server
3. **Use example responses** - They show the expected format
4. **Monitor console** - Postman console shows script outputs and warnings

## Troubleshooting

### Token Not Saving
- Check Postman console for errors
- Verify the Login response includes `success: true` and `data.token`
- Make sure the environment is selected

### 401 Unauthorized Errors
- Verify you've logged in successfully
- Check that `auth_token` is set in the environment
- Ensure the token hasn't expired

### Connection Errors
- Verify your server is running on the correct port
- Check the `base_url` environment variable
- Ensure CORS is enabled on the server

## Additional Notes

- The collection uses Bearer token authentication
- All requests include proper Content-Type headers
- Error responses follow a consistent format
- Success responses include a `success: true` flag

